<?php
$themename = "Mad Magazine";
$shortname = "Mad";
$theme_current_version = "1.1";
$theme_url = "http://www.tiagonoronha.com";


$pn_categories_obj = get_categories('hide_empty=0');
$pn_categories = array();

foreach ($pn_categories_obj as $pn_cat) {
	$pn_categories[$pn_cat->cat_ID] = $pn_cat->cat_name;
}

$categories_tmp = array_unshift($pn_categories, "Select a category:");

$options = array (
        
				array(	"name" => "Configuration Options",
						"type" => "subhead"),

				array(	"name" => "Logo",
					    "id" => $shortname."_logo_url",
						"desc" => "Enter the full address to where your logo is located. <b>(Eg. http://www.google.com/logo.gif).<br /> Max width is <b>400px</b>. Recommended height is <b>125px</b>.",
					    "std" => "",
					    "type" => "text"),

				array( 	"name" => "Featured Category",
					   	"desc" => "Select the category that you would like to have displayed in the featured section on your homepage.",
						"id" => $shortname."_featured_category",
						"std" => "Select a category:",
						"type" => "select",
						"options" => $pn_categories),
						
				array(	"name" => "Block of news #1 (Title)",
					    "id" => $shortname."_block1_title",
						"desc" => "Enter the name for \"Block of news #1\". <b>(Eg. \"Art/Culture\")</b>.",
					    "std" => "",
					    "type" => "text"),

				array( 	"name" => "Block of news #1 (Category)",
					   	"desc" => "Select the category where the posts will be pulled off.",
						"id" =>  $shortname."_block1_cat",
						"std" => "Select a category:",
						"type" => "select",
						"options" => $pn_categories),

				array(	"name" => "Block of news #1 (Number of posts)",
					    "id" => $shortname."_block1_number",
						"desc" => "Enter the number of post you want to show on this block. <b>(Eg. 5)</b>.",
					    "std" => "",
					    "type" => "text"),
						
				array(	"name" => "Block of news #2 (Title)",
					    "id" => $shortname."_block2_title",
						"desc" => "Enter the name for \"Block of news #2\". <b>(Eg. \"Art/Culture\")</b>.",
					    "std" => "",
					    "type" => "text"),
						
				array( 	"name" => "Block of news #2 (Category)",
					   	"desc" => "Select the category where the posts will be pulled off.",
						"id" =>  $shortname."_block2_cat",
						"std" => "Select a category:",
						"type" => "select",
						"options" => $pn_categories),


				array(	"name" => "Block of news #2 (Number of posts)",
					    "id" => $shortname."_block2_number",
						"desc" => "Enter the number of post you want to show on this block. <b>(Eg. 5)</b>.",
					    "std" => "",
					    "type" => "text"),
						
				array(	"name" => "Block of news #3 (Title)",
					    "id" => $shortname."_block3_title",
						"desc" => "Enter the name for \"Block of news #3\". <b>(Eg. \"Art/Culture\")</b>.",
					    "std" => "",
					    "type" => "text"),
						
				array( 	"name" => "Block of news #3 (Category)",
					   	"desc" => "Select the category where the posts will be pulled off.",
						"id" =>  $shortname."_block2_cat",
						"std" => "Select a category:",
						"type" => "select",
						"options" => $pn_categories),


				array(	"name" => "Block of news #3 (Number of posts)",
					    "id" => $shortname."_block3_number",
						"desc" => "Enter the number of post you want to show on this block. <b>(Eg. 5)</b>.",
					    "std" => "",
					    "type" => "text"),

                array(    "name" => "Advertisement",
                        "type" => "subhead"),

				array(	"name" => "468x60 Banner",
					    "id" => $shortname."_banner_468",
						"desc" => "Enter the full address to where your banner is located. <b>(Eg. http://www.google.com/banner.gif)</b>.",
					    "std" => "",
					    "type" => "text"),
						
				array(	"name" => "468x60 Link",
					    "id" => $shortname."_banner_468_link",
						"desc" => "Enter the link destination for the 468x60 banner. <b>(Eg. http://www.google.com)</b>.",
					    "std" => "",
					    "type" => "text"),
						
				array(	"name" => "300x250 Banner",
					    "id" => $shortname."_banner_300",
						"desc" => "Enter the full address to where your banner is located. <b>(Eg. http://www.google.com/banner.gif)</b>.",
					    "std" => "",
					    "type" => "text"),
						
				array(	"name" => "300x250 Link",
					    "id" => $shortname."_banner_300_link",
						"desc" => "Enter the link destination for the 300x250 banner. <b>(Eg. http://www.google.com)</b>.",
					    "std" => "",
					    "type" => "text"),
						
				array(	"name" => "230x230 Banner",
					    "id" => $shortname."_banner_230",
						"desc" => "Enter the full address to where your banner is located. <b>(Eg. http://www.google.com/banner.gif)</b>.",
					    "std" => "",
					    "type" => "text"),
						
				array(	"name" => "230x230 Link",
					    "id" => $shortname."_banner_230_link",
						"desc" => "Enter the link destination for the 230x230 banner. <b>(Eg. http://www.google.com)</b>.",
					    "std" => "",
					    "type" => "text"),
          );

function mytheme_add_admin() {

   global $themename, $shortname, $options;

    if ( $_GET['page'] == basename(__FILE__) ) {
    
        if ( 'save' == $_REQUEST['action'] ) {
	
                foreach ($options as $value) {
					if($value['type'] != 'multicheck'){
                    	update_option( $value['id'], $_REQUEST[ $value['id'] ] ); 
					}else{
						foreach($value['options'] as $mc_key => $mc_value){
							$up_opt = $value['id'].'_'.$mc_key;
							update_option($up_opt, $_REQUEST[$up_opt] );
						}
					}
				}

                foreach ($options as $value) {
					if($value['type'] != 'multicheck'){
                    	if( isset( $_REQUEST[ $value['id'] ] ) ) { update_option( $value['id'], $_REQUEST[ $value['id'] ]  ); } else { delete_option( $value['id'] ); } 
					}else{
						foreach($value['options'] as $mc_key => $mc_value){
							$up_opt = $value['id'].'_'.$mc_key;						
							if( isset( $_REQUEST[ $up_opt ] ) ) { update_option( $up_opt, $_REQUEST[ $up_opt ]  ); } else { delete_option( $up_opt ); } 
						}
					}
				}
                header("Location: themes.php?page=functions.php&saved=true");
                die;

        } else if( 'reset' == $_REQUEST['action'] ) {

            foreach ($options as $value) {
				if($value['type'] != 'multicheck'){
                	delete_option( $value['id'] ); 
				}else{
					foreach($value['options'] as $mc_key => $mc_value){
						$del_opt = $value['id'].'_'.$mc_key;
						delete_option($del_opt);
					}
				}
			}
            header("Location: themes.php?page=functions.php&reset=true");
            die;

        }
    }

    add_theme_page($themename." Options", "$themename Options", 'edit_themes', basename(__FILE__), 'mytheme_admin');
}

//add_theme_page($themename . 'Header Options', 'Header Options', 'edit_themes', basename(__FILE__), 'headimage_admin');

function headimage_admin(){
    
}

function mytheme_admin() {

    global $themename, $shortname, $options;

    if ( $_REQUEST['saved'] ) echo '<div id="message" class="updated fade"><p><strong>'.$themename.' settings saved.</strong></p></div>';
    if ( $_REQUEST['reset'] ) echo '<div id="message" class="updated fade"><p><strong>'.$themename.' settings reset.</strong></p></div>';
    
?>
<div class="wrap">
<h2 class="updatehook"><?php echo $themename; ?> settings</h2>

<form method="post">

<table class="form-table">

<?php //option_wrapper_header(array("name"=>"Header Image")); ?>

<?php //option_wrapper_footer(array("desc"=>"If you have GD2 support enabled on your server and the style you've selected supports it, you can generate a header image automatically.")); ?>

<?php foreach ($options as $value) { 
    
    switch ( $value['type'] ) {
        case 'subhead':
        ?>
            </table>
            
            <h3><?php echo $value['name']; ?></h3>
            
            <table class="form-table">
        <?php
        break;
        case 'text':
        option_wrapper_header($value);
        ?>
                <input name="<?php echo $value['id']; ?>" id="<?php echo $value['id']; ?>" type="<?php echo $value['type']; ?>" value="<?php if ( get_settings( $value['id'] ) != "") { echo get_settings( $value['id'] ); } else { echo $value['std']; } ?>" />
        <?php
        option_wrapper_footer($value);
        break;
        
        case 'select':
        option_wrapper_header($value);
        ?>
                <select name="<?php echo $value['id']; ?>" id="<?php echo $value['id']; ?>">
                    <?php foreach ($value['options'] as $option) { ?>
                    <option<?php if ( get_settings( $value['id'] ) == $option) { echo ' selected="selected"'; } elseif ($option == $value['std']) { echo ' selected="selected"'; } ?>><?php echo $option; ?></option>
                    <?php } ?>
                </select>
        <?php
        option_wrapper_footer($value);
        break;
        
        case 'textarea':
        $ta_options = $value['options'];
        option_wrapper_header($value);
        ?>
                <textarea name="<?php echo $value['id']; ?>" id="<?php echo $value['id']; ?>" cols="<?php echo $ta_options['cols']; ?>" rows="<?php echo $ta_options['rows']; ?>"><?php 
                if( get_settings($value['id']) != "") {
                        echo get_settings($value['id']);
                    }else{
                        echo $value['std'];
                }?></textarea>
        <?php
        option_wrapper_footer($value);
        break;

        case "radio":
        option_wrapper_header($value);
        
         foreach ($value['options'] as $key=>$option) { 
                $radio_setting = get_settings($value['id']);
                if($radio_setting != ''){
                    if ($key == get_settings($value['id']) ) {
                        $checked = "checked=\"checked\"";
                        } else {
                            $checked = "";
                        }
                }else{
                    if($key == $value['std']){
                        $checked = "checked=\"checked\"";
                    }else{
                        $checked = "";
                    }
                }?>
                <input type="radio" name="<?php echo $value['id']; ?>" value="<?php echo $key; ?>" <?php echo $checked; ?> /><?php echo $option; ?><br />
        <?php 
        }
         
        option_wrapper_footer($value);
        break;
        
        case "checkbox":
        option_wrapper_header($value);
                        if(get_settings($value['id'])){
                            $checked = "checked=\"checked\"";
                        }else{
                            $checked = "";
                        }
                    ?>
                    <input type="checkbox" name="<?php echo $value['id']; ?>" id="<?php echo $value['id']; ?>" value="true" <?php echo $checked; ?> />
        <?php
        option_wrapper_footer($value);
        break;

        default:

        break;
    }
}
?>

</table>

<p class="submit">
<input name="save" type="submit" value="Save changes" />    
<input type="hidden" name="action" value="save" />
</p>
</form>
<form method="post">
<p class="submit">
<input name="reset" type="submit" value="Reset" />
<input type="hidden" name="action" value="reset" />
</p>
</form>

<?php
}

function option_wrapper_header($values){
    ?>
    <tr valign="top"> 
        <th scope="row"><?php echo $values['name']; ?>:</th>
        <td>
    <?php
}

function option_wrapper_footer($values){
    ?>
        <br /><br />
        <?php echo $values['desc']; ?>
        </td>
    </tr>
    <?php 
}

function mytheme_wp_head() { /*?>
<link href="<?php bloginfo('template_directory'); ?>/style.php" rel="stylesheet" type="text/css" />
<?php*/ }

function mytheme_admin_head(){ 
    global $theme_current_version;
    global $theme_url;
    global $themename;
    ?>
    <script type="text/javascript">  
     jQuery(document).ready(function() {  
         jQuery.get('http://literalbarrage.org/lblgversion.txt', function(newversion){  
            if (<?php echo $theme_current_version; ?> < newversion) {
                 jQuery('#wpbody > .wrap > h2.updatehook').after('<div id="message" class="updated fade"><p><strong>Theme Update available. Click <a href="<?php echo $theme_url;?>">here</a> for details.</strong></p></div>');
                jQuery('#rightnow .youare').after('<p class="themehas"><?php echo $themename; ?> has an <a href="<?php echo $theme_url; ?>">available update</a>.</p>');
            }  
         });  
     });  
     </script>
<?php }

if ( function_exists('register_sidebar') )
register_sidebar();

$use_custom_header = $shortname."_use_custom_header";
if(get_settings($use_custom_header) == true){
    // Set up custom header code
    define('HEADER_TEXTCOLOR', 'cfcfd0');
    define('HEADER_IMAGE', '%s/styles/default/newbanner2.png');
    define('HEADER_IMAGE_WIDTH', '1024');
    define('HEADER_IMAGE_HEIGHT', '279');

    add_custom_image_header('header_style', 'elbee_admin_header_style');
}

function header_style() {
?>
<style type="text/css">
#header{
    background: url(<?php header_image() ?>) bottom right no-repeat;
}
<?php if ( 'blank' == get_header_textcolor() ) { ?>
#header h1, #header #description {
    display: none;
}
<?php } else { ?>
#header h1 a, #description {
    color:#<?php header_textcolor() ?>;
}
#desc {
    margin-right: 30px;
}
<?php } ?>
</style>
<?php
}

function elbee_admin_header_style() {
?>
<style type="text/css">
#headimg{
    background: url(<?php header_image() ?>) bottom right no-repeat;
    height: <?php echo HEADER_IMAGE_HEIGHT; ?>px;
    width:<?php echo HEADER_IMAGE_WIDTH; ?>px;
      padding:0 0 0 18px;
}

#headimg h1{
    padding-top:40px;
    margin: 0;
}
#headimg h1 a{
    color:#<?php header_textcolor() ?>;
    text-decoration: none;
    border-bottom: none;
}
#headimg #desc{
    color:#<?php header_textcolor() ?>;
    font-size:1em;
    margin-top:-0.5em;
}

#desc {
    display: none;
}

<?php if ( 'blank' == get_header_textcolor() ) { ?>
#headimg h1, #headimg #desc {
    display: none;
}
#headimg h1 a, #headimg #desc {
    color:#<?php echo HEADER_TEXTCOLOR ?>;
}
<?php } ?>

</style>
<?php
}

add_action('wp_head', 'mytheme_wp_head');
add_action('admin_head','mytheme_admin_head');
add_action('admin_menu', 'mytheme_add_admin'); 
?>