<?php
/*
Plugin Name: Featured Category Slideshow - FCS
Plugin URI: http://www.perfectsurf.de
Description: Used to create a slideshow out of the 4 newest posts in the featured-category. Highly based on the excellent <a href="http://www.wpelements.com/the-featured-content-gallery-plugin/">Featured Content Plugin</a> by Jason Schuller, which uses <a href="http://smoothgallery.jondesign.net/">SmoothGallery</a> by JonDesign. I just changed Jasons plugin to make it a bit more dynamic and easier to use if it's always the 4 newest posts that should be used for the slideshow, so please feel free to give him the credits for this!
Version: 0.1
Author: Tobias Mathar
Author URI: http://www.perfectsurf.de
*/

/* options page */
$options_page = get_option('siteurl') . '/wp-admin/admin.php?page=fcs/options.php';
/* Adds our admin options under "Options" */
function gallery_options_page() {
	add_options_page('Featured Category Slideshow Options', 'FCS', 10, 'fcs/options.php');
}

function gallery_styles() {
    /* The next lines figures out where the javascripts and images and CSS are installed,
    relative to your wordpress server's root: */
    $gallery_path =  get_bloginfo('wpurl')."/wp-content/plugins/fcs/";

    /* The xhtml header code needed for gallery to work: */
	$galleryscript = "
	<!-- begin gallery scripts -->
    <link rel=\"stylesheet\" href=\"".$gallery_path."css/jd.gallery.css\" type=\"text/css\" media=\"screen\" charset=\"utf-8\"/>
	<script type=\"text/javascript\" src=\"".$gallery_path."scripts/mootools.v1.11.js\"></script>
	<script type=\"text/javascript\" src=\"".$gallery_path."scripts/jd.gallery.js\"></script>
	<!-- end gallery scripts -->\n";
	/* Output $galleryscript as text for our web pages: */
	echo($galleryscript);
}

/* we want to add the above xhtml to the header of our pages: */
add_action('wp_head', 'gallery_styles');
add_action('admin_menu', 'gallery_options_page');
?>