<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">
<head>
	<title><?php bloginfo('name'); ?><?php wp_title(); ?></title>

	<meta http-equiv="Content-Type" content="<?php bloginfo('html_type'); ?>; charset=<?php bloginfo('charset'); ?>" />	
	<meta name="generator" content="WordPress <?php bloginfo('version'); ?>" /> <!-- leave this for stats please -->

	<link rel="stylesheet" href="<?php bloginfo('stylesheet_url'); ?>" type="text/css" media="screen" />
	<link rel="alternate" type="application/rss+xml" title="RSS 2.0" href="<?php bloginfo('rss2_url'); ?>" />
	<link rel="alternate" type="text/xml" title="RSS .92" href="<?php bloginfo('rss_url'); ?>" />
	<link rel="alternate" type="application/atom+xml" title="Atom 0.3" href="<?php bloginfo('atom_url'); ?>" />
	<link rel="pingback" href="<?php bloginfo('pingback_url'); ?>" />

	<?php wp_get_archives('type=monthly&format=link'); ?>
	<?php //comments_popup_script(); // off by default ?>
	<?php wp_head(); ?>
</head>
<body>
<div id="bottom_bg">
	<div id="container">
		<div id="top">
			<div id="toplinks">
				<a href="<?php bloginfo('url'); ?>/wp-login.php"><img src="<?php bloginfo('url'); ?>/wp-content/themes/ablogtheme/image/login.png" alt="Login" /></a>
				<a href="<?php bloginfo('url'); ?>/wp-admin/index.php"><img src="<?php bloginfo('url'); ?>/wp-content/themes/ablogtheme/image/admin.png" alt="Admin" /></a>
			</div>
			<div id="logo">
				<a href="<?php bloginfo('url'); ?>"><img src="<?php bloginfo('url'); ?>/wp-content/themes/ablogtheme/image/logo.jpg" alt="Blogtheme" /></a>
				<h1><a href="<?php echo get_option('home'); ?>/"><?php bloginfo('name'); ?></a></h1>
				<h3><?php bloginfo('description'); ?></h3>
			</div>
			<div id="nav">
				<ul>
					<li><a href="" class="active">Home</a></li>
					<li><a href="">Portfolio</a></li>
					<li><a href="">About</a></li>
					<li><a href="">Contact</a></li>
				</ul>
			</div>
		</div>
		<div id="header">
			<div class="head_box" id="about_me">
				<h3><span>About me</span></h3>
				<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam sollicitudin, nisl ut tempor porta, dui dui congue libero, at faucibus massa mi in risus. Aenean at risus. Morbi tempor tortor quis pede. Pellentesque felis ante, venenatis non, tristique in, pharetra non, nunc. Donec ornare tortor. Suspendisse in enim sit amet mauris sollicitudin feugiat. In massa. Duis sapien nisl, egestas in, mollis et, accumsan id, leo. Cras fringilla. Maecenas vitae urna quis orci sollicitudin tincidunt. Morbi purus felis, sollicitudin a, ultrices eu, commodo vitae, erat.</p>
			</div>
			<div id="subscription">
				<a href="<?php bloginfo_rss('rss2_url'); ?>"><img src="<?php bloginfo('url'); ?>/wp-content/themes/ablogtheme/image/subscribe.png" alt="Subscribe" /></a>
				<form id="email" action="">
					<fieldset>
						<input type="text" class="input" />
						<input type="image" src="<?php bloginfo('url'); ?>/wp-content/themes/ablogtheme/image/go_b.png" class="submit" />
					</fieldset>
				</form>
			</div>
		</div>
		<div id="content">
			<?php if(have_posts()) : ?>
			<div id="entries">
				<?php while(have_posts()) : the_post(); ?>
				<div class="entry" id="post-<?php the_ID(); ?>">
					<div class="date">posted<span><?php the_time('d/m/y') ?></span></div>
					<h2><a href="<?php the_permalink(); ?>"  title="<?php the_title(); ?>"><?php the_title(); ?></a></h2>
					<div class="tags"><span><?php echo get_the_tag_list('',', ',''); ?>
</span></div>
					<div class="clear"></div>
					<?php the_content(); ?>
				</div>
				<?php comments_template(); ?>
				<?php endwhile; ?>
			</div>
			<?php else : ?>
			<div id="entries">
				<div class="entry">
					<h2>No Entries Found</h2>
				</div>
			</div>
			<?php endif; ?>
		</div>
		<div id="sidebar">
			<div id="search">
				<form method="get" id="searchform" action="<?php bloginfo('home');?>/">
					<fieldset>
						<input type="text" class="input" value="<?php the_search_query(); ?>" name="s" id="s" />
						<input type="image" src="<?php bloginfo('url'); ?>/wp-content/themes/ablogtheme/image/go.png" class="submit" />
					</fieldset>
				</form>
			</div>
			<div id="tags">
				<h4><strong><span>Tags</span></strong></h4>
				<div class="boxcenter"><div class="boxbottom"><div class="boxtop">
						<?php wp_tag_cloud('smallest=8&largest=15'); ?>
				</div></div></div>
			</div>
			<div id="categories">
				<h4><strong><span>Categories</span></strong></h4>
				<div class="boxcenter"><div class="boxbottom"><div class="boxtop">
					<ul>
						<?php wp_list_cats('sort_column=name$hierarchical=0'); ?>
					</ul>
				</div></div></div>
			</div>
			<div id="archives">
				<h4><strong><span>Archives</span></strong></h4>
				<div class="boxcenter"><div class="boxbottom"><div class="boxtop">
					<ul>
						<?php wp_get_archives('type=monthly'); ?>
					</ul>
				</div></div></div>
			</div>
		</div>
		<div class="clear"></div>
		<div id="footer">
			<div class="foot_box" id="recent_posts">
				<h5><span>Recent Posts</span></h5>
				<ul>
					<?php get_archives('postbypost', 6); ?>
				</ul>
			</div>
			<div class="foot_box" id="recent_comments">
				<h5><span>Recent Commnets</span></h5>
				<ul>
					<?php get_recent_comments(); ?>
				</ul>
			</div>
			<div id="socialize">
				<h5><span>Socialize</span></h5>
				<ul>
					<li><a class="s_1" href="">Last.fm</a></li>
					<li><a class="s_2" href="">Facebook</a></li>
					<li><a class="s_3" href="">Linkedin</a></li>
					<li><a class="s_4" href="">MySpace</a></li>
					<li><a class="s_5" href="">Twitter</a></li>
					<li><a class="s_6" href="">Vimeo</a></li>
				</ul>
			</div>
			<div class="clear"></div>
			<div id="footlinks">
<big><strong><font style="color: #33627C;text-decoration: none;">&copy; <?php echo date('Y'); ?> <?php bloginfo('name'); ?></font></strong></big>
			</div>
			<div id="footnote">
<!-- FOOTER CREDITS LINK -->	
<p>
<small><strong><a href="http://www.freethemelayouts.com/" style="color: #33627C;text-decoration: none;" title="Free WordPress Themes">Free WordPress Themes</a> by [i] <a href="http://www.iwebsitetemplate.com" style="color: #33627C;text-decoration: none;" title="Website Templates">Website Templates</a><strong></small>
</p>
			</div>
			<div class="clear"></div>
		</div>
	</div>
</div>
</body>
</html>