<?php get_header(); ?>


<?php if (have_posts()) : ?>

<?php while (have_posts()) : the_post(); ?>

<?php if (in_category(showcase)) continue; ?>

<div class="post" id="post-<?php the_ID(); ?>">

<div class="entry-header">
<a class="entry-title" href="<?php the_permalink() ?>" title="<?php the_title(); ?>"><?php the_title(); ?></a>
<div class="date-wrap"><span class="entry-date"><?php the_time('j/m/y'); ?></span></div>
</div>

<div class="entry-content entry-content-index">
<?php the_content( __('')); ?>
</div>

<div class="entry-footer">

<span class="entry-comment"><?php comments_popup_link( __( '0 Comments', 'blank' ), __( '1 Comment', 'blank' ), __( '% Comments', 'blank' ), 'comments-link', __('-', 'blank')); ?></span>
<span class="category-image"></span><span class="entry-category"><?php the_category(', ') ?></span>
<a class="continue-reading" href="<?php the_permalink() ?>" title="<?php the_title(); ?>"></a>
<div class="clear"></div>
<hr />
</div><!-- end .entry-footer -->
</div><!-- end .post -->

<?php endwhile; ?>
        
<div class="navigation">
	<div class="nav-prev"><?php next_posts_link( __('&laquo; Older Entries', 'blank')) ?></div>
	<div class="nav-next"><?php previous_posts_link( __('Newer Entries &raquo;', 'blank')) ?></div>
</div>

<?php else : ?>

<h2><?php _e('The page you`re looking for doesn`t exist', 'blank'); ?></h2>

<div class="search-404">
    <?php _e('Do you want to search for it?', 'blank'); ?><br />
    <?php include (TEMPLATEPATH . "/searchform.php"); ?>
</div>
        
<?php endif; ?>
<?php get_sidebar(); ?>

<?php get_footer(); ?>
