<?php get_header(); ?>
<div id="content">
	<?php if (have_posts()) : ?>
	<?php $post = $posts[0]; // Hack. Set $post so that the_date() works. ?>
	<h3>Search Result</h3>
	
	<?php while (have_posts()) : the_post(); ?>
	<div class="entrybottom">
		<div class="entrytop">
			<div class="entry" id="post-<?php the_ID(); ?>">
				<div class="ehead">
					<h2><a href="<?php the_permalink() ?>" rel="bookmark" title="Continue reading <?php the_title(); ?>"><?php the_title() ?> </a></h2>
					<div class="entryinfo">
					<?php edit_post_link('Edit', '', ' | '); ?> Posted by <strong><?php the_author(); ?></strong> on <?php the_date(); ?> | Filed under <?php the_category(', ') ?> | <?php comments_popup_link('0 Comments', '1 Comment', '% Comments'); ?>
					</div>
				</div>
				<?php the_content("Read full story &raquo;"); ?>
			</div>
		</div>
	</div>
	<?php endwhile; ?>

	<div class="navigation">
		<div class="alignleft"><?php next_posts_link('&laquo; Previous Entries') ?></div>
		<div class="alignright"><?php previous_posts_link('Next Entries &raquo;') ?></div>
		<div class="clearer"></div>
	</div>
	<?php else : ?>
	<div class="entrybottom">
		<div class="entrytop">
			<div class="entry">
				<h2>Not Found</h2>
				<p>Sorry, but you are looking for something that isn't here.</p>
			</div>
		</div>
	</div>
	<?php endif; ?>
</div>
<?php get_sidebar(); ?>
<?php get_footer(); ?>
