<?php get_header(); ?>

	<div id="content">
    	<div id="single">

		   <?php if (have_posts()) : ?>
    
          <?php $post = $posts[0]; // Hack. Set $post so that the_date() works. ?>
          <?php /* If this is a category archive */ if (is_category()) { ?>
            <h3 class="arc">Archive for the &#8216;<?php single_cat_title(); ?>&#8217; Category</h3>
          <?php /* If this is a tag archive */ } elseif( is_tag() ) { ?>
            <h3 class="arc">Posts Tagged &#8216;<?php single_tag_title(); ?>&#8217;</h3>
          <?php /* If this is a daily archive */ } elseif (is_day()) { ?>
            <h3 class="arc">Archive for <?php the_time('F jS, Y'); ?></h3>
          <?php /* If this is a monthly archive */ } elseif (is_month()) { ?>
            <h3 class="arc">Archive for <?php the_time('F, Y'); ?></h3>
          <?php /* If this is a yearly archive */ } elseif (is_year()) { ?>
            <h3 class="arc">Archive for <?php the_time('Y'); ?></h3>
          <?php /* If this is an author archive */ } elseif (is_author()) { ?>
            <h3 class="arc">Author Archive</h3>
          <?php /* If this is a paged archive */ } elseif (isset($_GET['paged']) && !empty($_GET['paged'])) { ?>
            <h3 class="arc">Blog Archives</h3>
          <?php } ?>
    
            <?php while (have_posts()) : the_post(); ?>
            <div class="entry">
                <div class="entry2">
                    <div class="bg">
                        <div class="etext">
                            <!-- start entry post -->
                            <div class="ehead">
                                <h2><a href="<?php the_permalink() ?>" rel="bookmark" title="Continue reading <?php the_title(); ?>"><?php the_title(); ?></a></h2>
                                <div class="entryinfo"><?php edit_post_link('Edit', '', ' |'); ?> Posted by <strong><?php the_author(); ?></strong> on <?php the_time('d M Y'); ?> under <?php the_category(', ') ?> | <?php comments_popup_link('0 Comments', '1 Comment', '% Comments'); ?>
                                </div>
                            </div>
                            <div class="post">
                            <?php the_excerpt(); ?>
                            </div>     
                             <!-- end entry post -->   
                        </div>
                    </div>
                </div>
            </div> 
            <?php endwhile; ?>
    
            <div class="navigation">
                <div class="alignleft"><?php next_posts_link('&laquo; Older Entries') ?></div>
                <div class="alignright"><?php previous_posts_link('Newer Entries &raquo;') ?></div>
            </div>
            <?php else :
        
                if ( is_category() ) { // If this is a category archive
                    printf("<h2>Sorry, but there aren't any posts in the %s category yet.</h2>", single_cat_title('',false));
                } else if ( is_date() ) { // If this is a date archive
                    echo("<h2>Sorry, but there aren't any posts with this date.</h2>");
                } else if ( is_author() ) { // If this is a category archive
                    $userdata = get_userdatabylogin(get_query_var('author_name'));
                    printf("<h2>Sorry, but there aren't any posts by %s yet.</h2>", $userdata->display_name);
                } else {
                    echo("<h2>No posts found.</h2>");
                }
                get_search_form();
        
            endif;
        ?>

		</div>
	</div>

<?php get_sidebar(); ?>

<?php get_footer(); ?>
